;I2Cslavc.asm john waller 2002oct05 to experiment with slave end of I2C MSSP.
;Simple transfer of two bytes slave to master with handshake, but no error checking.

#DEFINE BANK0   BCF $03,5   ;STATUS bit 5
#DEFINE BANK1   BSF $03,5   ;STATUS bit 5

INDF:    .EQU $00	;Indirect address, bank 0, 1, 2, 3.
TMRO:	 .EQU $01	;Timer 0 value, bank 0, 3.
OPTION:  .EQU $01	;Option register, bank 1, 3.
PCL:     .EQU $02	;Program counter low byte, bank 0, 1, 2, 3.
STATUS:  .EQU $03	;Status flags, bank 0, 1, 2, 3.
FSR:     .EQU $04	;Indirect address pointer, bank 0, 1, 2, 3.
PORTA:   .EQU $05	;Port A, bank 0.
TRISA:   .EQU $05	;Port A direction register, bank 1.
PORTB:   .EQU $06	;Port B, bank 0, 2.
TRISB:   .EQU $06	;Port B direction register, bank 1, 3.
PORTC:   .EQU $07	;Port C, bank 0.
TRISC:   .EQU $07	;Port C direction register, bank 1.
PORTD:   .EQU $08	;Port D, bank 0.
TRISD:   .EQU $08	;Port D direction register, bank 1.
PORTE:   .EQU $09	;Port E, bank 0.
TRISE:   .EQU $09	;Port E direction register, bank 1.
PCLATH:	 .EQU $0A	;Program counter high byte setting register, bank 0, 1, 2, 3.
INTCON:  .EQU $0B	;Interrupt control, bank 0, 1, 2, 3.
PIR1:	 .EQU $0C	;Peripheral interrupt flags, bank 0.
PIE1:    .EQU $0C	;Peripheral interrupt enable, bank 1.
PIR2:    .EQU $0D	;Peripheral interrupt flags, bank 0.
PIE2:    .EQU $0D	;Peripheral interrupt enable, bank 1.
SSPCON2: .EQU $11	;SSP configuration, bank 1.
SSPBUF:	 .EQU $13	;SSP address and data buffer, bank 0.
SSPADD:  .EQU $13	;SSP master baud rate/slave address, bank 1.
SSPCON:  .EQU $14	;SSP configuration, bank 0.
SSPSTAT: .EQU $14	;SSP status, bank 1.
ADCON1:	 .EQU $1F	;Port A A/D control register, bank 1.

;........GENERAL PURPOSE REGISTERS

LOOPA:  .EQU $20   ; general loop

;........CONSTANT VALUES

SLVADD: .EQU $10	;Slave address; upper 7 bits; equate must be even;
			;do not use F8h, FAh, FCh, FEh, or zero.
			;16F877 manual says only 112 valid addresses available;
			;don't know what the other invalid ones are.

;........BIT VALUES

ACKDT:  .EQU 5		;SSP master acknowledge data.
ACKEN:  .EQU 4		;SSP master 
ACKSTAT:.EQU 6		;SSP master acknowledge status.
BCLIE   .EQU 3		;Bus collision interrupt enable.
BCLIF:  .EQU 3		;Bus collision interrupt flag.
BF:     .EQU 0		;SSP buffer full.
C:      .EQU 0          ;Carry status.
CKE:    .EQU 6		;Clock edge select.
CKP:	.EQU 4		;Hold/enable SSP clock pulse by slave.
DNA     .EQU 5		;Last byte received or transmitted was data or address.
F:      .EQU 1          ;Select file register.
GCEN:   .EQU 7		;SSP general call enable.
GIE:    .EQU 7		;General interrupt enable.
P:      .EQU 4		;Stop bit.
PEIE:   .EQU 6		;Peripheral interrupt enable.
PEN:    .EQU 2		;SSP master stop enable.
RCEN:   .EQU 3		;SSP receive enable.
RNW:    .EQU 2		;Read/write information following the last address match.
RP0:    .EQU 5          ;STATUS bank control bit.
RP1:    .EQU 6          ;STATUS bank control bit.
RSEN:	.EQU 1		;SSP master repeat start enable.
SEN:    .EQU 0		;SSP master start enable.
SMP:    .EQU 7		;Slew rate control.
SSPIE:  .EQU 3		;SSP interrupt enable.
SSPIF:  .EQU 3		;SSP interrupt flag.
SSPEN:  .EQU 5		;Configure SDA and SCL pins for SSP.
SSPOV:  .EQU 6		;SSP receive overflow detect.
UA:     .EQU 1		;Update address; 10-bit address mode only.
W:      .EQU 0          ;Select working register.
WCOL:   .EQU 7		;SSP write collision detect.
Z:      .EQU 2          ;Zero status.

;..........

        .ORG $0004
	goto INTERRUPT
        .ORG $0005

	goto INITIALISE	;jump over sub-page 0 tables to INITIALISE.

		;page 0, sub-page 0 tables: make sure they don't overrun.
		
;..........

BACKGROUND:	;Main part of program in background; entered from INITIALISE.
		;Called from none; calls SEND2BYTNOINT.
	call SEND2BYTNOINT	;Receive two bytes of data w/o interrupts or error ckeck.
	bsf PORTE,0		;Set port pin as debug check.
BACK1:	goto BACK1		;Pause.
	goto BACKGROUND		;Loop back.

;..........

CHECKANDSTOP:	;Writes selected registers to ports and pauses.
		;Called from none; calls, none.
	BANK0			;
	andlw %11100000		;Write high bits in W to port C
	movwf PORTC		;to indicate where in program stop occurred.
	bsf PORTE,2		;Signal program has reached here.
	btfss PIR1,SSPIF	;Show SSP
	goto CHAST1		;interrupt
	bsf PORTC,2		;bit
	goto CHAST2		;on
CHAST1:	bcf PORTC,2		;port C,2.
CHAST2:	BANK1			;Write
	movf SSPSTAT,W		;register
	BANK0			;contents
	movwf PORTB		;to port.
	movf SSPCON,W		;Write register
	movwf PORTD		;contents to port.
CHAST3:	goto CHAST3		;Loop indefinitely.

;..........

INITI2CSLVE:	;Initialises the I2C slave device.
		;Called from INITIALISE; calls none.
	movlw %00110110		;Bits 7, 6, flags; bit 5 enable SDA and SCL port pins;
	movwf SSPCON		;bit 4, clock release control;
				;bits 3..0, I2C 7-bit address slave mode.
	BANK1			;
	movlw %10000000		;Bit 7, slew rate control disabled; bit 6, comply with
	movwf SSPSTAT		;I2C protocol; bits 5..0, flags.
	clrf SSPCON2		;All bits flags.
	movlw SLVADD		;Set slave address
	movwf SSPADD		;for this module.
	bank 0			;
	return			;
	
;..........

INITIALISE:	;Initialising ports and others. Entered at startup.
		;Called from none; calls INITI2CSLVE.
	clrf PCLATH		;Page and sub-page 0.
	clrf STATUS		;Bank 0 and clear all flags.
				;Clear all gpr locations in banks 0 and 1.
	movlw $20		;First gpr address in bank 0
	movwf FSR		;to indirect address register.
INITB0:	clrf INDF		;Clear location pointed to.
	incf FSR,F		;Select next address.
	btfss FSR,7		;Skip if end of bank 0.
	goto INITB0		;
	movlw $A0		;First gpr address in bank 1
	movwf FSR		;to indirect address register.
INITB1:	clrf INDF		;Clear location pointed to.
	incf FSR,F		;Select next address.
	btfss STATUS,Z		;Skip if end of bank 1.
	goto INITB1		;
				;Set up ports and timers.
	clrf PORTA		;Clear port.
        clrf PORTB		;Clear port.
	clrf PORTC		;Clear port.
        clrf PORTD		;Clear port.
	clrf PORTE		;Clear port.
        BANK1			;Select bank 1.
	movlw %00000110		;Port A as digital
	movwf ADCON1		;input/output.
	movlw %00111111		;Port A0-A5
        movwf TRISA     	;as input.
        clrf TRISB      	;Port B0-B7 as output.
	movlw %00011000		;Port C all bits output, except
	movwf TRISC		;3 and 4 must be input for I2C.
	movlw %00000000		;Port D bits all
	movwf TRISD		;outputs.
	movlw %00000000		;Port E all bits as output,
	movwf TRISE		;disable slave port.
        BANK0			
        clrf INTCON		;No interrupts or timers for the first try.
        call INITI2CSLVE	;Initialise I2C slave mode.
        goto BACKGROUND	;
        
;...........

INTERRUPT:	;Interrupt routine goes here.
	retfie		;

;..........

SEND2BYTNOINT:	;Send two bytes of data with no interrupt set.
		;No errors are checked for here.
		;Second dummy byte is sent repeatedly unless master sends NACK.
		;Called from BACKGROUND; calls none.
				;Receive the address.
S2BNI1:	btfss PIR1,SSPIF	;Loop until this slave address is
	goto S2BNI1		;in SSP buffer.
	movf SSPBUF,W		;Dummy read of buffer to empty it.
	bcf PIR1,SSPIF		;Clear interrupt flag.
				;Send first data byte.
	movlw %10110111		;Send a dummy
	movwf SSPBUF		;data byte.
	bsf SSPCON,CKP		;Release clock to allow transmission.
S2BNI2:	btfss PIR1,SSPIF	;Loop until master
	goto S2BNI2		;response signified.
	bcf PIR1,SSPIF		;Clear interrupt flag.
	BANK1			;
	btfss SSPSTAT,RNW	;Skip if more data required.
	goto S2BNI5		;Otherwise exit.
S2BNI3:	BANK0			;
				;Send second data byte.
	movlw %11100110		;Send a dummy
	movwf SSPBUF		;data byte.
	bsf SSPCON,CKP		;Release clock to allow transmission.
S2BNI4:	btfss PIR1,SSPIF	;Loop until master
	goto S2BNI4		;response signified.
	bcf PIR1,SSPIF		;Clear interrupt flag.
	BANK1			;
	btfss SSPSTAT,RNW	;Skip if more data required.
	goto S2BNI5		;Otherwise exit.
	goto S2BNI3		;
S2BNI5:	btfss SSPSTAT,P		;Loop until
	goto S2BNI5		;'P' flag set.
	BANK0			;
	bsf PORTE,1		;set port pin to signify 'stop' received.
	return			;
	
;..........

        .END
